/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.math.BigInteger;

public class HexString {
    private static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHex(byte value, boolean pad) {
        return HexString.convertToHex(value, 2, pad);
    }

    public static String toHex(byte value) {
        return HexString.convertToHex(value, 2, false);
    }

    public static String toHex(short value, boolean pad) {
        return HexString.convertToHex(value, 4, pad);
    }

    public static String toHex(short value) {
        return HexString.convertToHex(value, 4, false);
    }

    public static String toHex(int value, boolean pad) {
        return HexString.convertToHex(value, 8, pad);
    }

    public static String toHex(int value) {
        return HexString.convertToHex(value, 8, false);
    }

    public static String toHex(long value, boolean pad) {
        return HexString.convertToHex(value, 16, pad);
    }

    public static String toHex(long value) {
        return HexString.convertToHex(value, 16, false);
    }

    public static String toHex(Number value, boolean pad) {
        String result = "";
        if (value instanceof Byte) {
            result = HexString.convertToHex(value.longValue(), 2, pad);
        } else if (value instanceof Short) {
            result = HexString.convertToHex(value.longValue(), 4, pad);
        } else if (value instanceof Integer) {
            result = HexString.convertToHex(value.longValue(), 8, pad);
        } else if (value instanceof Long) {
            result = HexString.convertToHex(value.longValue(), 16, pad);
        } else if (value instanceof Double) {
            result = HexString.convertToHex(value.longValue(), 16, pad);
        } else if (value instanceof BigInteger) {
            result = ((BigInteger)value).toString(16).toLowerCase();
        }
        return result;
    }

    public static String toHex(Number value) {
        return HexString.toHex(value, false);
    }

    public static String toHex(byte[] value) {
        return HexString.toHex(value, 0, 0, false);
    }

    public static String toHex(byte[] value, int grouping, int lineLength, boolean showText) {
        return HexString.toHex(value, 0, value == null ? 0 : value.length, grouping, lineLength, showText);
    }

    public static String toHex(byte[] value, int startIx, int length, int grouping, int lineLength, boolean showText) {
        StringBuffer result = new StringBuffer();
        StringBuffer ascii = new StringBuffer("    ");
        if (value != null) {
            int ix;
            for (ix = 0; ix < length; ++ix) {
                if (lineLength > 0 && ix > 0 && ix % lineLength == 0) {
                    if (showText) {
                        result.append(ascii.toString());
                    }
                    ascii.setLength(0);
                    ascii.append("    ");
                    result.append('\n');
                } else if (grouping > 0 && ix > 0 && ix % grouping == 0) {
                    result.append(' ');
                }
                byte bv = value[ix + startIx];
                result.append(HEXDIGITS[bv >> 4 & 0xF]);
                result.append(HEXDIGITS[bv & 0xF]);
                if (!showText) continue;
                if (Character.isISOControl((char)bv)) {
                    ascii.append('.');
                    continue;
                }
                ascii.append((char)bv);
            }
            if (showText && length > 0) {
                if (lineLength > 0) {
                    int remains = lineLength - (length - 1) % lineLength - 1;
                    int spacerLength = 2 * remains;
                    if (grouping > 0) {
                        spacerLength += remains / grouping;
                    }
                    for (ix = 0; ix < spacerLength; ++ix) {
                        result.append(' ');
                    }
                }
                result.append(ascii.toString());
            }
        }
        return result.toString();
    }

    public static byte[] toHexBytes(String text) {
        int size = 0;
        if (text != null) {
            size = text.length();
        }
        byte[] result = new byte[(size + 1) / 2];
        int resultIx = 0;
        for (int ix = 0; ix < size; ++ix) {
            int charValue = Character.digit(text.charAt(ix), 16);
            if (charValue == -1) {
                throw new NumberFormatException("Invalid hex character specified");
            }
            if (ix % 2 == 0) {
                result[resultIx] = (byte)(charValue << 4);
                continue;
            }
            int n = resultIx++;
            result[n] = (byte)(result[n] | (byte)charValue);
        }
        return result;
    }

    protected static String convertToHex(long value, int width, boolean pad) {
        char[] result = new char[width];
        int i = width;
        do {
            result[--i] = HEXDIGITS[(int)value & 0xF];
        } while ((pad || (value >>>= 4) != 0L) && i > 0);
        return new String(result, i, width - i);
    }
}

